//	BeansTestClient.java
//
//	Test client for EJBs.
//
//

import javax.naming.*;
import java.rmi.*;
import javax.rmi.PortableRemoteObject;
import javax.ejb.CreateException;
import java.util.Properties;
import Alkindi.BusinessDataTypes.*;
import Alkindi.BusinessServices.*;
import Alkindi.BusinessServices.BeanIface.*;


public class BeansTestClient {
	
	//	usage()
	//	
	public static void usage() {
		System.out.println("Usage: BeansTestClient [bean]");
		System.out.println("\twhere [bean] is one of the following");
		System.out.println("\t\tacc	= AccountManager");
		System.out.println("\t\tadm	= AdminManager");
		System.out.println("\t\tclu	= ClusterManager");
		System.out.println("\t\trat	= RatingManager");
		System.out.println("\t\trec	= RecommendationManager");
		System.out.println("\t\tsea	= SearchManager");
	}

	//	getCtx()
	//
	public static Context getCtx() throws javax.naming.NamingException
	{
		System.setSecurityManager(new RMISecurityManager());
		System.out.print("Getting initial context...");
		Context ctx = null;
		ctx = new InitialContext();
		System.out.println("done.");
		System.out.println("Context environment:");
		final java.util.Hashtable env = ctx.getEnvironment();
		java.util.Enumeration kenum = env.keys();
		while (kenum.hasMoreElements()) {
			Object key = kenum.nextElement();
			System.out.println(key.toString() + ": " + env.get(key));
		}
		return ctx;

	}

	//	doCtxLookup()
	//
	public static Object doCtxLookup(String nameToLookup) throws AlkExcept {
		Object obj = null;
		try {
			Context ctx = getCtx();
			obj = ctx.lookup(nameToLookup);
		}
		catch (javax.naming.NamingException ne) {
			throw new AlkExcept(ne.toString(), 7000);
		}
		return obj;

	}

	//	doAcctMgr()
	//
	public static void doAcctMgr() throws AlkExcept, RemoteException {
		System.out.println("\n**** Testing Account Manager ****\n");
		Object obj = doCtxLookup("AcctMgrHome");
		IAccountManagerHome home = (IAccountManagerHome)PortableRemoteObject.narrow(obj, IAccountManagerHome.class);
		
	}

	//	doAdminMgr()
	//
	public static void doAdminMgr() throws AlkExcept, RemoteException {
		System.out.println("\n**** Testing Admin Manager ****\n");
		try {
			IAdminManagerHome home = (IAdminManagerHome)PortableRemoteObject.narrow(doCtxLookup("AdminMgrHome"), IAdminManager.class);
			IAdminManagerBean adminMgr = home.create();
			adminMgr.getPresets("dummy");
			System.out.println("AdminMgr::getPresets() called ");
		}
		catch (CreateException ce) {
			throw new AlkExcept(ce.toString(), 7000);
		}
	}

	//	doClusterMgr()
	//
	public static void doClusterMgr() throws AlkExcept, RemoteException {
		System.out.println("\n**** Testing Cluster Manager ****\n");
		try {
			IClusterManagerHome home = (IClusterManagerHome)PortableRemoteObject.narrow(doCtxLookup("ClusterMgrHome"), IClusterManagerHome.class);
			IClusterManagerBean clusterMgr = home.create();
			SystemUser su = new SystemUser(1);
			clusterMgr.clusterUser(su);
			System.out.println("Successfully called clusterUser()");
			clusterMgr.recalcStats();
			System.out.println("Successfully called recalcStats()");
			clusterMgr.recalcProductStats();
			System.out.println("Successfully called recalcProductStats()");
			clusterMgr.regenerateClusters();
			System.out.println("Successfully called regenerateClusters()");
		}
		catch(CreateException ce) {
			throw new AlkExcept(ce.toString(), 7000);
		}
	}

	//	doRatingMgr()
	//
	public static void doRatingMgr() throws AlkExcept, RemoteException {
		System.out.println("\n**** Testing Rating Manager ****\n");
		try {
			IRatingManagerHome home = (IRatingManagerHome)PortableRemoteObject.narrow(doCtxLookup("RatingMgrHome"), IRatingManagerHome.class);
			IRatingManagerBean ratMgr = home.create();
			//ProductList pl = ratMgr.getInitialProductsToRate();

			SystemUser noUser = new SystemUser(193);
			ProductList pl = ratMgr.getProductsToRate(noUser, 8);
//			ProductList pl = ratMgr.getProductsToRate(null, 8);
			System.out.println("Called getProductsToRate()");

			for (int idx = 0; idx < pl.size(); idx++) {
				System.out.println("Product #" + idx + " id=" + pl.get(idx).productID);
			}
		}
		catch (CreateException ce) {
			throw new AlkExcept(ce.toString(), 7000);
		}
	}
	
	//	doRecMgr()
	//
	public static void doRecMgr() throws AlkExcept, RemoteException	{
		try {
			IRecommendationManagerHome recMgrHome = (IRecommendationManagerHome)PortableRemoteObject.narrow(doCtxLookup("RecMgrHome"), IRecommendationManagerHome.class);
			IRecommendationManagerBean recMgr = recMgrHome.create();
			SystemUser su = new SystemUser(1);
		 	double akx = recMgr.getAlkindex(su);
			System.out.println("RecMgr::getAlkindex() returned " + akx);
			ProductCluster pc = new ProductCluster(1);
			RecommendationList recList = recMgr.getRecommendations(su, 4, pc);
			for (int idx=0; idx<recList.size(); idx++) {
				Recommendation rec = recList.get(idx);
				
				if (rec == null) {
					System.out.println("Rec #" + idx + ": NULL recommendation returned.");
					continue;
				}
				if (rec.ratedProduct == null) {
					System.out.println("Rec #:" + idx + " has null product");
					continue;
				}
				System.out.println("Rec #" + idx + ": Product id " + rec.ratedProduct.productID + " eval=" + rec.evaluation);
			}
		}
		catch (CreateException ce) {
			throw new AlkExcept(ce.toString(), 7000);
			
		}
	}
	

	//	doSearchMgr()
	//
	public static void doSearchMgr() throws AlkExcept, RemoteException{
		System.out.println("\n**** Testing Search Manager ****");
		try {
			ISearchManagerHome smHome = (ISearchManagerHome)PortableRemoteObject.narrow(doCtxLookup("SearchMgrHome"), ISearchManagerHome.class);
			ISearchManagerBean searchMgr = smHome.create();
			System.out.println("Retrieved searchMgr Bean.");
			SystemUserList sul = searchMgr.findMember("Query");
			System.out.println("Called findMember");
			for (int idx = 0; idx < sul.size(); idx ++) {
				System.out.println("Found user id=" + sul.get(idx).userID);
			}
		}
		catch (CreateException ce) {
			throw new AlkExcept(ce.toString(), 7000);
		}
	}


	//	main()
	//
	public static void main(String[] args) {
		if (args.length == 0) {
			usage();
			System.exit(1);
		}
		
		try {
			if (args[0].compareTo("acc") == 0) {
				doAcctMgr();
			}
			else if (args[0].compareTo("adm") == 0) {
				doAdminMgr();
			}
			else if (args[0].compareTo("clu") == 0) {
				doClusterMgr();
			}
			else if (args[0].compareTo("rat") == 0) {
				doRatingMgr();
			}
			else if (args[0].compareTo("rec") == 0) {
				doRecMgr();
			}
			else if (args[0].compareTo("sea") == 0) {
				doSearchMgr();
			}
			else {
				usage();
			}

/*			Object obj = null;
			obj = ctx.lookup("RatingMgrHome");
			System.out.println("Found RatingMgrBean.");
			ISearchManagerHome smHome = (ISearchManagerHome)PortableRemoteObject.narrow(ctx.lookup("SearchMgrHome"), ISearchManagerHome.class);
			
			ISearchManagerBean searchMgr = smHome.create();
			System.out.println("Retrieved searchMgr Bean.");
			System.out.println("Found user id=" + su.userID);
*			obj = ctx.lookup("RecMgrBean");
			System.out.println("Found RecMgrBean.");
			obj = (IAdminManagerHome)ctx.lookup("AdminMgrBean");
			System.out.println("Found AdminMgrBean..");
			obj = ctx.lookup("ClusterMgrBean");
			System.out.println("Found ClusterMgrBean.");
			obj = ctx.lookup("SearchMgrBean");
			System.out.println("Found SearchMgrBean.");*/
//			IAccountManagerHome home = (IAccountManagerHome)ctx.lookup("AcctMgrBean");
//			System.out.println("Got AcctMgr Home Interface.");
//			IAccountManagerBean acctMgr = home.create();
//			System.out.println("Got AcctMgr remote interface.");
//			Alkindi.BusinessDataTypes.SystemUser newUser = acctMgr.createUser();
//			System.out.println("Created new user with id=" + newUser.userID);
//			ctx.close();	 
		}
		catch (AlkExcept ae) {
			System.out.println("Caught AlkExcept: " + ae.toString());
		}
		catch(Exception e) {
			System.err.println("Caught exception: " + e.toString());
			e.printStackTrace();
		}
		
	}
}
